/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.TestCase;
import weka.core.CheckGOE;
import weka.core.CheckOptionHandler;
import weka.core.SerializationHelper;
import weka.datagenerators.DataGenerator;

public abstract class AbstractDataGeneratorTest
extends TestCase {
    protected DataGenerator m_Generator;
    protected StringWriter m_Output;
    protected CheckOptionHandler m_OptionTester;
    protected CheckGOE m_GOETester;

    public AbstractDataGeneratorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.m_Generator = this.getGenerator();
        this.m_Output = new StringWriter();
        this.m_Generator.setOutput(new PrintWriter(this.m_Output));
        this.m_OptionTester = this.getOptionTester();
        this.m_GOETester = this.getGOETester();
    }

    @Override
    protected void tearDown() {
        this.m_Generator = null;
        this.m_Output = null;
        this.m_GOETester = null;
        this.m_OptionTester = null;
    }

    public abstract DataGenerator getGenerator();

    protected CheckOptionHandler getOptionTester() {
        CheckOptionHandler result = new CheckOptionHandler();
        result.setOptionHandler(this.getGenerator());
        result.setUserOptions(new String[0]);
        result.setSilent(true);
        return result;
    }

    protected CheckGOE getGOETester() {
        CheckGOE result = new CheckGOE();
        result.setObject(this.getGenerator());
        result.setIgnoredProperties(String.valueOf(result.getIgnoredProperties()) + ",datasetFormat");
        result.setSilent(true);
        return result;
    }

    public void testOptions() {
        try {
            this.m_Generator.setOptions(this.m_Generator.getOptions());
        }
        catch (Exception e) {
            AbstractDataGeneratorTest.fail("setOptions(getOptions()) does not work: " + e.getMessage());
        }
    }

    public void testMakeData() {
        try {
            DataGenerator.makeData(this.m_Generator, new String[0]);
        }
        catch (Exception e) {
            AbstractDataGeneratorTest.fail("Generation of data failed: " + e.getMessage());
        }
    }

    public void testSerialVersionUID() {
        if (SerializationHelper.needsUID(this.m_Generator.getClass())) {
            AbstractDataGeneratorTest.fail("Doesn't declare serialVersionUID!");
        }
    }

    public void testListOptions() {
        if (!this.m_OptionTester.checkListOptions()) {
            AbstractDataGeneratorTest.fail("Options cannot be listed via listOptions.");
        }
    }

    public void testSetOptions() {
        if (!this.m_OptionTester.checkSetOptions()) {
            AbstractDataGeneratorTest.fail("setOptions method failed.");
        }
    }

    public void testDefaultOptions() {
        if (!this.m_OptionTester.checkDefaultOptions()) {
            AbstractDataGeneratorTest.fail("Default options were not processed correctly.");
        }
    }

    public void testRemainingOptions() {
        if (!this.m_OptionTester.checkRemainingOptions()) {
            AbstractDataGeneratorTest.fail("There were 'left-over' options.");
        }
    }

    public void testCanonicalUserOptions() {
        if (!this.m_OptionTester.checkCanonicalUserOptions()) {
            AbstractDataGeneratorTest.fail("setOptions method failed");
        }
    }

    public void testResettingOptions() {
        if (!this.m_OptionTester.checkSetOptions()) {
            AbstractDataGeneratorTest.fail("Resetting of options failed");
        }
    }

    public void testGlobalInfo() {
        if (!this.m_GOETester.checkGlobalInfo()) {
            AbstractDataGeneratorTest.fail("No globalInfo method");
        }
    }

    public void testToolTips() {
        if (!this.m_GOETester.checkToolTips()) {
            AbstractDataGeneratorTest.fail("Tool tips inconsistent");
        }
    }
}

